
%% Matlab Code for generating breath noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;
%% Load healthy person lung sound file here
load posterior_right
Healthy_person_sound        = data(1:end);
%% Load 10 identical simulated Hoevers fine crackles here 
load SF1_Hoevers
load SF2_Hoevers
load SF3_Hoevers
load SF4_Hoevers
load SF5_Hoevers
load SF6_Hoevers
load SF7_Hoevers
load SF8_Hoevers
load SF9_Hoevers
load SF10_Hoevers
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SF1_Hoevers     = [zeros(1,1000),SF1_Hoevers,zeros(1,Signal_length-(1000+length(SF1_Hoevers)))];
SF2_Hoevers     = [zeros(1,3000),SF2_Hoevers,zeros(1,Signal_length-(3000+length(SF2_Hoevers)))];
SF3_Hoevers     = [zeros(1,7000),SF3_Hoevers,zeros(1,Signal_length-(7000+length(SF3_Hoevers)))];
SF4_Hoevers     = [zeros(1,12000),SF4_Hoevers,zeros(1,Signal_length-(12000+length(SF4_Hoevers)))];
SF5_Hoevers     = [zeros(1,14000),SF5_Hoevers,zeros(1,Signal_length-(14000+length(SF5_Hoevers)))];
SF6_Hoevers     = [zeros(1,17000),SF6_Hoevers,zeros(1,Signal_length-(17000+length(SF6_Hoevers)))];
SF7_Hoevers     = [zeros(1,20000),SF7_Hoevers,zeros(1,Signal_length-(20000+length(SF7_Hoevers)))];
SF8_Hoevers     = [zeros(1,23000),SF8_Hoevers,zeros(1,Signal_length-(23000+length(SF8_Hoevers)))];
SF9_Hoevers     = [zeros(1,27500),SF9_Hoevers,zeros(1,Signal_length-(27500+length(SF9_Hoevers)))];
SF10_Hoevers    = [zeros(1,30000),SF10_Hoevers,zeros(1,Signal_length-(30000+length(SF10_Hoevers)))];
Ten_identical_simulated_Hoevers_fine_crackles       = SF1_Hoevers+SF2_Hoevers+SF3_Hoevers+SF4_Hoevers+SF5_Hoevers+SF6_Hoevers+SF7_Hoevers+SF8_Hoevers+SF9_Hoevers+SF10_Hoevers;
Ten_identical_simulated_Hoevers_fine_crackles       = Ten_identical_simulated_Hoevers_fine_crackles(1:end);
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop        = -10:1:10                                              %% Start signal to noise ratio loop
for iterative_loop  = 1:201                                                 %% Start number of iterations loop 
%% Autoregressive model to generate breath noise
[p,e]           = armcov(Healthy_person_sound, 10);                         %% Autoregressive model for generating breath noise
breath_noise    = filter(1,p,randn(1,Signal_length)); 
%% Calculate scaling factor for changing the signal to noise ratio
Crackle_power   = sum(abs(Ten_identical_simulated_Hoevers_fine_crackles).*abs(Ten_identical_simulated_Hoevers_fine_crackles))/Signal_length;                          
Noise_Power     = sum(abs(breath_noise).*abs(breath_noise))/Signal_length;
Scaling_factor  = (Crackle_power/Noise_Power)*10^(-SNR_loop/10);  
Signal          = sqrt(Scaling_factor)*breath_noise+Ten_identical_simulated_Hoevers_fine_crackles; %% Signal with 10 identical Hoevers fine crackles buried under breath noise

%% Use your separation technique here


end
end